<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-05-05 18:38
 */
interface ReturnsellbillreviewDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Returnsellbillreview 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param returnsellbillreview primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Returnsellbillreview returnsellbillreview
 	 */
	public function insert($returnsellbillreview);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Returnsellbillreview returnsellbillreview
 	 */
	public function update($returnsellbillreview);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillid($value);

	public function queryByReviewType($value);

	public function queryByReviewuserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByBillid($value);

	public function deleteByReviewType($value);

	public function deleteByReviewuserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>